package gov.va.med.mhv.health.web.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

import javax.faces.FacesException;
import javax.faces.application.NavigationHandler;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;

public class MHVExceptionHandler extends ExceptionHandlerWrapper {
	private ExceptionHandler wrapped;

	public MHVExceptionHandler(ExceptionHandler wrapped){
		this.wrapped=wrapped;
	}
	
	@Override
	public ExceptionHandler getWrapped() {
		return wrapped;
	}
	
	
	public void handle() throws FacesException{
		
		for (Iterator<ExceptionQueuedEvent> i = getUnhandledExceptionQueuedEvents().iterator(); i.hasNext();) {
			
			ExceptionQueuedEvent event = i.next();
			ExceptionQueuedEventContext context = (ExceptionQueuedEventContext) event.getSource();
			Throwable t = context.getException();
			if (t instanceof Exception) {
                FacesContext fc = FacesContext.getCurrentInstance();
                Map<String, Object> requestMap = fc.getExternalContext().getRequestMap();
                NavigationHandler nav = fc.getApplication().getNavigationHandler();
                try {
                    // Push some useful stuff to the request scope for
                    // use in the page
                	String stackTrace = formatStackTrace(t);
                	requestMap.put("rootcause", t.getCause());
                    requestMap.put("stackTrace", stackTrace);
                    requestMap.put("date", new Date());
                    nav.handleNavigation(fc, null, "error");
                    fc.renderResponse();
                } finally {
                    i.remove();
                }
            } 
		}
		
		getWrapped().handle();
	}
	
	
	public String formatStackTrace(Throwable t) {
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		t.printStackTrace(pw);
		String stackTrace=sw.toString(); 
		StringTokenizer st = new StringTokenizer(stackTrace,"\r\n");
	    StringBuilder sb = new StringBuilder();
	    sb.append("<table>");
	    sb.append("\n");
	    while(st.hasMoreElements()){
	    	sb.append("<tr>");
	    	String token = st.nextToken();
	    	sb.append("<td>");
    		sb.append(token);
    		sb.append("</td>");
    		sb.append("</tr>");
	    }
	    sb.append("</table>");
	    return sb.toString();
	}
}
